import { CommonModule } from '@angular/common';
import { Component } from '@angular/core';
import { RouterOutlet } from '@angular/router';
import Data from '../assets/data/Assignment02.json';
import { Books } from './books/books';
import { Campus } from './campus/campus';
import { Footer } from './footer/footer';
import { Header } from './header/header';
import { MaterialModule } from './modules/material-ui.module';
import { A2Personal, CampusData, MyBooks } from './tomlisteInterface';
@Component({
  standalone: true,
  selector: 'app-root',
  imports: [RouterOutlet,MaterialModule,CommonModule,Header,Footer,Books,Campus],
  templateUrl: './app.html',
  styleUrls: ['./app.css']
})
export class App {
  protected title = 'A2tomliste';
  tomlistePersonal: A2Personal = Data.a2Personal;
  tomlisteMyBooks: MyBooks[] = Data.myBooks;
  tomlisteCampus: CampusData[] = Data.campusData;
}
